library(imager)
library(matrixStats)
library(scales)
library(gtools)
library(inflection)

flatDirectory = '/Users/gfivash/Dropbox/Greg/Work/PhD/Thesis Chapters/Chapter 3 - Sediment hummocks/Data Chapter 3 submission/Figure 5 - oxygenation event/Oxygen drainage exp data/Data-Yue-20180731/E1/E1-flatone-2h vs 10h-0-100-jpg/'
hummockDirectory = '/Users/gfivash/Dropbox/Greg/Work/PhD/Thesis Chapters/Chapter 3 - Sediment hummocks/Data Chapter 3 submission/Figure 5 - oxygenation event/Oxygen drainage exp data/Data-Yue-20180731/E5/E5-hummock1cm-2h vs 10h-jpg/'
hollowDirectory = '/Users/gfivash/Dropbox/Greg/Work/PhD/Thesis Chapters/Chapter 3 - Sediment hummocks/Data Chapter 3 submission/Figure 5 - oxygenation event/Oxygen drainage exp data/Data-Yue-20180731/E6/E6-hollow1cm-2h vs 10h-jpg/'

inputDirectory = '/Volumes/Greg HD/Yue Oxygen data/Data-Yue-20180731/E5/E5-hummock1cm-2h vs 10h-jpg/'

setwd(inputDirectory)

filelist = mixedsort(dir())
n_files = length(filelist)

# time settings
starttime = as.POSIXct('2018-06-20 17:36:00')
interval = 300#120  # 2min=120s between adjacent two images

oxygenDeclineRate = rep(NA, times = n_files)
halfSaturationDepth.cm = rep(NA, times = n_files)
halfSaturationDepthWindowed.cm = rep(NA, times = n_files)

i = 200
for(i in 1:n_files){

  #i = round(runif(n = 1, min = 700, max = length(filelist)))
  filename = filelist[i]
  
  # load images, grayscale, crop, convert class from image to matrix
  p = load.image(filename)
  p.g = grayscale(p)
  p.g.c = as.cimg(p.g[205:660,120:710, 1, 1])
  m = as.matrix(p.g.c)
  m = m*100
  
  # synchronize depth layers in cm and in pixel
  depth = seq(0,6.24, length.out = dim(m)[2])# - sedimentSurfaceDepth.cm # depth in "cm"
  
  # calculate the mean values and SE in columns
  #se = colSds(m)/sqrt(dim(m)[1])
  oxygen.mean = colMeans(m)
  interval = 10
  oxygenWindow = c()
  depthWindow = c()
  for(i_window in 1:length(oxygen.mean)){
    start = i_window
    end = start + interval
    
    oxygenWindow[i_window] = mean(oxygen.mean[start:end], na.rm = T)
    depthWindow[i_window] = mean(depth[start:end], na.rm = T)
  }
  
  plot(depthWindow ~ oxygenWindow, xlim = c(0.0005,100),ylim = c(6.24,0), type = 'l')
  points(depth ~ oxygen.mean, xlim = c(0.0005,100),ylim = c(6.24,0), pch = '.')
  
  # If hummock E5: (get rid of oxygen bubble)
  if(i >= 270 & i <= 310){
    halfSaturationDepth.cm[i] = min(depth[oxygen.mean > 48 & oxygen.mean < 52])
    halfSaturationDepthWindowed.cm[i] = min(depth[oxygenWindow > 48 & oxygenWindow < 52])
  } else {
    halfSaturationDepth.cm[i] = depth[which.min(abs(50 - oxygen.mean))]
    halfSaturationDepthWindowed.cm[i] = depthWindow[which.min(abs(50 - oxygenWindow))]
  }
  
  print(paste(i,'/',n_files, sep = ' '))
}

plot(halfSaturationDepth.cm, type = 'l', ylim = c(6,0))
plot(halfSaturationDepthWindowed.cm, type = 'l', ylim = c(6,0))

# Fix erosion within hummock --------
h = halfSaturationDepthWindowed.cm
t = 1:length(halfSaturationDepthWindowed.cm)
h[1:274] = h[1:274] + 0.69
h[275:599] = h[275:599] + 0.3
h[600:915] = h[600:915] + 0.2
plot(h ~ t, type = 'l', ylim = c(8,0), xlim = c(0,1600))
halfSaturationDepthCorr.cm = h

# filter= 1:274
# plot(h[filter] ~ t[filter], type = 'l', ylim = c(10,0), xlim = c(0,1600))

# -----------------------------------

h = halfSaturationDepthCorr.cm
#h = halfSaturationDepthWindowed.cm
for(i in 2:length(h)){
  #if(h[i] > 2.55){
  if(h[i] > 2.65){
#  if(h[i] > 3.35){
  #if(h[i] > 3.7){
#  if(h[i] > 4.36 | h[i] < 4){
    h[i] = h[i - 1]
  }
}

time = starttime + interval*((1:length(h)) - 1)
plot(h ~ time, type = 'l', ylim = c(6,0))
m = lm(h ~ poly(time,2))
lines(predict(m) ~ time, col = 2)

diff = halfSaturationDepthCorr.cm - h
# diff = halfSaturationDepthWindowed.cm - h
oxygen50.cm = m$residuals + diff
#oxygen50.cm[oxygen50.cm < -0.15] = NA

sedimentShape = rep('flat', times = length(h))
experiment = rep('E4', times = length(h))
plot(oxygen50.cm ~ time, type = 'l', ylim = c(6,-2))

d = data.frame(oxygen50.cm, time, sedimentShape, experiment)
outputDirectory = '/Users/gfivash/Desktop/'
setwd(outputDirectory)
write.csv(d, 'hummockE5.csv', row.names = F)



